/*
 * Decompiled with CFR 0.152.
 */
package com.bonrix.voice;

import com.bonrix.voice.Container;
import com.tino1b2be.audio.AudioFileException;
import com.tino1b2be.dtmfdecoder.DTMFDecoderException;
import com.tino1b2be.dtmfdecoder.DTMFUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.core.useragent.UserAgent;

public class Util {
    public static boolean isNumeric(String s) {
        return s != null && s.matches("[-+]?\\d*\\.?\\d+");
    }

    public static void doPostCallProcessing(UserAgent userAgent, int callDuration, Date callTime, Logger logger, String audioFileName) {
        String dtmfVal = "";
        try {
            dtmfVal = Util.findDtmf(Util.convertRawToWav(audioFileName));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        Util.callApi(userAgent, callDuration, callTime, dtmfVal, logger);
        System.exit(0);
    }

    public static void callApi(UserAgent userAgent, int callDuration, Date callTime, String dtmfVal, Logger logger) {
        try {
            String inputLine;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("uniqueId", Container.bonrixConfig.getUniqueId());
            map.put("callDueSec", String.valueOf(callDuration));
            map.put("callTime", Util.dateToString(callTime));
            map.put("dtmfVal", dtmfVal);
            String urlString = userAgent.getConfig().getCallEndApiUrl();
            urlString = Util.formatString(urlString, map);
            URL url = new URL(urlString);
            URLConnection conn = url.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String finalMessage = "";
            while ((inputLine = br.readLine()) != null) {
                finalMessage = finalMessage + inputLine;
            }
            br.close();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    public static String formatString(String pattern, Map arguments) {
        Map entries = arguments;
        for (Map.Entry entry : entries.entrySet()) {
            pattern = pattern.replace("{" + (String)entry.getKey() + "}", String.valueOf(entry.getValue()));
        }
        return pattern;
    }

    public static String dateToString(Date date) {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(date);
    }

    private static String findDtmf(String audioFilePathString) throws AudioFileException, DTMFDecoderException, IOException {
        if (audioFilePathString == null || audioFilePathString.isEmpty()) {
            return null;
        }
        DTMFUtil dtmf = new DTMFUtil(audioFilePathString);
        dtmf.decode();
        String left_channel = dtmf.getDecoded()[0];
        return left_channel;
    }

    private static String convertRawToWav(String srcFileName) throws IOException {
        if (srcFileName == null || srcFileName.isEmpty()) {
            return null;
        }
        String destFileName = srcFileName + ".wav";
        File inputFile = new File(srcFileName);
        AudioInputStream ais = new AudioInputStream(new FileInputStream(inputFile), new AudioFormat(8000.0f, 16, 1, true, false), inputFile.length() / 2L);
        AudioSystem.write(ais, AudioFileFormat.Type.WAVE, new File(destFileName));
        return destFileName;
    }
}

